-- View: gepland_view

-- DROP VIEW gepland_view;
-- View: gepland_view
/*
DROP VIEW rapportage_planningperperiode_view_plancapaciteit ;
DROP VIEW planningperperiode_overzicht_view ;
DROP VIEW planningperperiode_overzicht_shape_view;
DROP VIEW rapportage_pertype_view ;
DROP VIEW rapportage_pertype_view_plancapaciteit ;
DROP VIEW rapportage_planningperperiode_view ;
DROP VIEW pertype_overzicht_view_plancapaciteit ;
DROP VIEW pertype_overzicht_view ;
DROP VIEW pertype_overzicht_shape_view ;
DROP VIEW pertype_overzicht_shape_view_plancapaciteit ;

DROP VIEW rapportage_planninghov_view ;
drop view volledig_aantal_view ;*/
--drop view gerealiseerd_view cascade;

--DROP VIEW gepland_view cascade;


-- View: gerealiseerd_view

-- DROP VIEW gerealiseerd_view;
--DROP VIEW volledig_overzicht_shape_view cascade;
CREATE OR REPLACE VIEW gerealiseerd_view AS 
 SELECT p.bouwplanid AS id, p.periodeomschrijving AS omschrijving, p.periodeid, COALESCE(sum(
        CASE
            WHEN p.factsoortid <> 1 AND p.factsoortid <> 2 AND p.factsoortid <> 19 AND p.factsoortid <> 27 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0::bigint) AS r_t, COALESCE(max(
        CASE
            WHEN p.factsoortid = 3 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_eg_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 5 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_eg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 21 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_eg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 4 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_eg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 6 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_mg_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 8 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_mg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 22 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_mg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 7 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_mg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 9 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_on_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 11 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_on_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 23 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_on_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 10 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_on_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 13 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_eg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 24 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_eg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 12 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_eg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 15 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_mg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 25 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_mg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 14 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_mg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 17 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_on_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 26 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_on_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 16 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_on_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 18 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 2 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_s
   FROM realisatieaantal_per_soort_per_periode_per_bouwplan p
  GROUP BY p.bouwplanid, p.periodeid, p.periodeomschrijving
  ORDER BY p.bouwplanid, p.periodeomschrijving;

ALTER TABLE gerealiseerd_view OWNER TO rwbp;


CREATE OR REPLACE VIEW gepland_view AS 
 SELECT p.bouwplanid AS id, p.periodeid, p.periodeomschrijving AS omschrijving, sum(
        CASE
            WHEN p.factsoortid <> 1 AND p.factsoortid <> 2 AND p.factsoortid <> 19 AND p.factsoortid <> 27 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_t, COALESCE(max(
        CASE
            WHEN p.factsoortid = 3 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 4 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 34 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_s3, COALESCE(COALESCE(max(
        CASE
            WHEN p.factsoortid = 37 THEN p.planningaantal
            ELSE NULL::integer
        END), 0), 0) AS p_h_eg_s4, COALESCE(max(
        CASE
            WHEN p.factsoortid = 5 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 31 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 21 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_eg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 6 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 7 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 35 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_s3, COALESCE(max(
        CASE
            WHEN p.factsoortid = 38 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_s4, COALESCE(max(
        CASE
            WHEN p.factsoortid = 8 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 32 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 22 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_mg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 9 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 10 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 36 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_s3, COALESCE(max(
        CASE
            WHEN p.factsoortid = 39 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_s4, COALESCE(max(
        CASE
            WHEN p.factsoortid = 11 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 33 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 23 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_h_on_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 12 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 13 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 28 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 24 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_eg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 14 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 15 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 29 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 25 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_mg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 16 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 17 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 30 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_m2, COALESCE(max(
        CASE
            WHEN p.factsoortid = 26 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_k_on_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 40 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_o_eg, COALESCE(max(
        CASE
            WHEN p.factsoortid = 41 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_o_mg, COALESCE(max(
        CASE
            WHEN p.factsoortid = 18 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_o_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 2 THEN p.planningaantal
            ELSE NULL::integer
        END), 0) AS p_s
   FROM planningaantal_per_soort_per_periode_per_bouwplan p
  GROUP BY p.bouwplanid, p.periodeomschrijving, p.periodeid
  ORDER BY p.bouwplanid, p.periodeomschrijving;

ALTER TABLE gepland_view OWNER TO rwbp;


-- View: planningsaantal_capaciteit

--DROP VIEW planningsaantal_capaciteit;

CREATE OR REPLACE VIEW planningsaantal_capaciteit AS 
 SELECT b.id AS bouwplanid, p.id AS periodeid, p.omschrijving AS periodeomschrijving, fmt.factsoortid, COALESCE(fmt.planningaantal, 0) AS planningaantal
   FROM bouwplan b, periode p, factmetperiode fmt
  WHERE fmt.bouwplanid = b.id AND fmt.periodeid = p.id AND b.the_geom IS NOT NULL AND b.statusprojectid <> 2 AND b.statusprojectid <> 10 AND ( SELECT ger.planningaantal <> 1
           FROM factmetperiode ger
          WHERE ger.factsoortid = 27 AND ger.periodeid = p.id AND ger.bouwplanid = b.id)
  ORDER BY b.id, p.id, p.omschrijving, fmt.factsoortid;

ALTER TABLE planningsaantal_capaciteit OWNER TO rwbp;

-- View: gepland_view_plancapaciteit

--DROP VIEW gepland_view_plancapaciteit;

CREATE OR REPLACE VIEW gepland_view_plancapaciteit AS 
 SELECT p.bouwplanid AS id, p.periodeid, p.periodeomschrijving AS omschrijving, sum(
        CASE
            WHEN p.factsoortid <> 1 AND p.factsoortid <> 2 AND p.factsoortid <> 19 AND p.factsoortid <> 27 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_t, max(
        CASE
            WHEN p.factsoortid = 3 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_g, max(
        CASE
            WHEN p.factsoortid = 4 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_s, max(
        CASE
            WHEN p.factsoortid = 34 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_s3, max(
        CASE
            WHEN p.factsoortid = 37 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_s4, max(
        CASE
            WHEN p.factsoortid = 5 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_m, max(
        CASE
            WHEN p.factsoortid = 31 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_m2, max(
        CASE
            WHEN p.factsoortid = 21 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_eg_o, max(
        CASE
            WHEN p.factsoortid = 6 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_g, max(
        CASE
            WHEN p.factsoortid = 7 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_s, max(
        CASE
            WHEN p.factsoortid = 35 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_s3, max(
        CASE
            WHEN p.factsoortid = 38 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_s4, max(
        CASE
            WHEN p.factsoortid = 8 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_m, max(
        CASE
            WHEN p.factsoortid = 32 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_m2, max(
        CASE
            WHEN p.factsoortid = 22 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_mg_o, max(
        CASE
            WHEN p.factsoortid = 9 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_g, max(
        CASE
            WHEN p.factsoortid = 10 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_s, max(
        CASE
            WHEN p.factsoortid = 36 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_s3, max(
        CASE
            WHEN p.factsoortid = 39 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_s4, max(
        CASE
            WHEN p.factsoortid = 11 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_m, max(
        CASE
            WHEN p.factsoortid = 33 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_m2, max(
        CASE
            WHEN p.factsoortid = 23 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_h_on_o, max(
        CASE
            WHEN p.factsoortid = 12 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_eg_s, max(
        CASE
            WHEN p.factsoortid = 13 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_eg_m, max(
        CASE
            WHEN p.factsoortid = 28 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_eg_m2, max(
        CASE
            WHEN p.factsoortid = 24 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_eg_o, max(
        CASE
            WHEN p.factsoortid = 14 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_mg_s, max(
        CASE
            WHEN p.factsoortid = 15 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_mg_m, max(
        CASE
            WHEN p.factsoortid = 29 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_mg_m2, max(
        CASE
            WHEN p.factsoortid = 25 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_mg_o, max(
        CASE
            WHEN p.factsoortid = 16 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_on_s, max(
        CASE
            WHEN p.factsoortid = 17 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_on_m, max(
        CASE
            WHEN p.factsoortid = 30 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_on_m2, max(
        CASE
            WHEN p.factsoortid = 26 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_k_on_o, max(
        CASE
            WHEN p.factsoortid = 40 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_o_eg, max(
        CASE
            WHEN p.factsoortid = 41 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_o_mg, max(
        CASE
            WHEN p.factsoortid = 18 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_o_o, max(
        CASE
            WHEN p.factsoortid = 2 THEN p.planningaantal
            ELSE NULL::integer
        END) AS p_s
   FROM planningsaantal_capaciteit p
  GROUP BY p.bouwplanid, p.periodeomschrijving, p.periodeid
  ORDER BY p.bouwplanid, p.periodeomschrijving;

ALTER TABLE gepland_view_plancapaciteit OWNER TO rwbp;



-- View: gerealiseerd_view

--DROP VIEW gerealiseerd_view;

CREATE OR REPLACE VIEW gerealiseerd_view AS 
 SELECT p.bouwplanid AS id, p.periodeomschrijving AS omschrijving, p.periodeid, COALESCE(sum(
        CASE
            WHEN p.factsoortid <> 1 AND p.factsoortid <> 2 AND p.factsoortid <> 19 AND p.factsoortid <> 27 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0::bigint) AS r_t, COALESCE(max(
        CASE
            WHEN p.factsoortid = 3 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_eg_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 5 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_eg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 21 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_eg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 4 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_eg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 6 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_mg_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 8 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_mg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 22 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_mg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 7 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_mg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 9 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_on_g, COALESCE(max(
        CASE
            WHEN p.factsoortid = 11 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_on_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 23 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_on_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 10 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_h_on_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 13 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_eg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 24 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_eg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 12 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_eg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 15 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_mg_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 25 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_mg_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 14 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_mg_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 17 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_on_m, COALESCE(max(
        CASE
            WHEN p.factsoortid = 26 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_on_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 16 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_k_on_s, COALESCE(max(
        CASE
            WHEN p.factsoortid = 18 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_o, COALESCE(max(
        CASE
            WHEN p.factsoortid = 2 THEN p.realisatieaantal
            ELSE NULL::integer
        END), 0) AS r_s
   FROM realisatieaantal_per_soort_per_periode_per_bouwplan p
  GROUP BY p.bouwplanid, p.periodeid, p.periodeomschrijving
  ORDER BY p.bouwplanid, p.periodeomschrijving;

ALTER TABLE gerealiseerd_view OWNER TO rwbp;

-- View: volledig_overzicht_shape_view

--DROP VIEW volledig_overzicht_shape_view;

CREATE OR REPLACE VIEW volledig_overzicht_shape_view AS 
 SELECT b.the_geom, b.id, b.naam, b.referentienummer, b.masterplan, b.bestemmingsplannaam, ot.type AS opdrachtgever, b.ontwikkelaar_namelijk AS opdrachtgever_namelijk, a.naam AS aanduiding, p.type AS plantype, w.type AS woonmilieu, b.woonmilieu_namelijk, g.naam AS gebruikgegevens,to_char(sv.prognose_start, 'DD-MM-YYYY') as prognose_start, to_char(sv.prognose_oplevering,'DD-MM-YYYY') as prognose_oplevering, sv.statusplanologisch, sv.statusproject, sv.status_namelijk, sv.alg_voortgang, sv.alg_toelichting, sv.plan_voortgang, sv.plan_toelichting, sv.start_voortgang, sv.start_toelichting, sv.bouwrijp_voortgang, sv.bouwrijp_toelichting, sv.vergunning_voortgang, sv.vergunning_toelichting, sv.overig_voortgang, sv.overig_toelichting
   FROM bouwplan b
   LEFT JOIN ontwikkelaartype ot ON b.ontwikkelaartypeid = ot.id
   LEFT JOIN aanduiding a ON b.aanduidingid = a.id
   LEFT JOIN plantype p ON b.plantypeid = p.id
   LEFT JOIN woonmilieu w ON b.woonmilieuid = w.id
   LEFT JOIN gebruikgegevens g ON b.gebruikgegevensid = g.id
   JOIN status_view sv ON b.id = sv.id;

ALTER TABLE volledig_overzicht_shape_view OWNER TO rwbp;

-- View: pertype_overzicht_shape_view

--DROP VIEW pertype_overzicht_shape_view;

CREATE OR REPLACE VIEW pertype_overzicht_shape_view AS 
 SELECT b.the_geom, b.id, b.naam, b.referentienummer, b.masterplan, b.bestemmingsplannaam, b.opdrachtgever, b.opdrachtgever_namelijk, b.aanduiding, b.plantype, b.woonmilieu, b.woonmilieu_namelijk, b.gebruikgegevens,b.prognose_start, b.prognose_oplevering, b.statusplanologisch, b.statusproject, b.status_namelijk, b.alg_voortgang, b.alg_toelichting, b.plan_voortgang, b.plan_toelichting, b.start_voortgang, b.start_toelichting, b.bouwrijp_voortgang, b.bouwrijp_toelichting, b.vergunning_voortgang, b.vergunning_toelichting, b.overig_voortgang, b.overig_toelichting, COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND (gepland_view.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7]))), 0::numeric) AS "2015Totaal", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Huur 2015", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30]))), 0::bigint) AS "Koop 2015", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "EigOnb2015", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40]))), 0::bigint) AS "Eg_2015", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41]))), 0::bigint) AS "Mg_2015", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39]))), 0::bigint) AS "TypeOnb2015", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Soc_2015", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11]))), 0::bigint) AS "Markt 2015", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "PriOnb2015", COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND (gepland_view.periodeid = ANY (ARRAY[8, 9, 10, 11, 12]))), 0::numeric) AS "15-19Tot", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Huur 15-19", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30]))), 0::bigint) AS "Koop 15-19", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "EigOnb15-19", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40]))), 0::bigint) AS "Eg_15-19", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41]))), 0::bigint) AS "Mg_15-19", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39]))), 0::bigint) AS "TypeOnb15-19", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Soc_15-19", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11]))), 0::bigint) AS "Markt15-19", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND (planningaantal_per_soort_per_periode_per_bouwplan.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "PriOnb15-19", COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND gepland_view.periodeid = 13), 0::numeric) AS "20-24Tot", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Huur 20-24", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30]))), 0::bigint) AS "Koop 20-24", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "EigOnb20-24", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40]))), 0::bigint) AS "Eg_20-24", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41]))), 0::bigint) AS "Mg_20-24", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39]))), 0::bigint) AS "TypeOnb20-24", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Soc_20-24", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11]))), 0::bigint) AS "Markt 20-24", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 13 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "PriOnb20-24", COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND gepland_view.periodeid = 14), 0::numeric) AS "25-29Tot", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Huur 25-29", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30]))), 0::bigint) AS "Koop 25-29", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "EigOnb25-29", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40]))), 0::bigint) AS "Eg_25-29", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41]))), 0::bigint) AS "Mg_25-29", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39]))), 0::bigint) AS "TypeOnb25-29", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Soc_25-29", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11]))), 0::bigint) AS "Markt 25-29", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 14 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "PriOnb25-29", COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND gepland_view.periodeid = 16), 0::numeric) AS "30 ev tot", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Huur 30 ev", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30]))), 0::bigint) AS "Koop 30 ev", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "EigOnb30 ev", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40]))), 0::bigint) AS "Eg_30 ev", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41]))), 0::bigint) AS "Mg_30 ev", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39]))), 0::bigint) AS "TypeOnb30 ev", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Soc_30 ev", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11]))), 0::bigint) AS "Markt 30 ev", COALESCE(( SELECT sum(planningaantal_per_soort_per_periode_per_bouwplan.planningaantal) AS sum
           FROM planningaantal_per_soort_per_periode_per_bouwplan
          WHERE planningaantal_per_soort_per_periode_per_bouwplan.bouwplanid = b.id AND planningaantal_per_soort_per_periode_per_bouwplan.periodeid = 16 AND (planningaantal_per_soort_per_periode_per_bouwplan.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "PriOnb30 ev"
   FROM volledig_overzicht_shape_view b;

ALTER TABLE pertype_overzicht_shape_view OWNER TO rwbp;


-- View: pertype_overzicht_shape_view_plancapaciteit

-- DROP VIEW pertype_overzicht_shape_view_plancapaciteit;

CREATE OR REPLACE VIEW pertype_overzicht_shape_view_plancapaciteit AS 
 SELECT b.the_geom, b.id, b.naam, b.referentienummer, b.masterplan, b.bestemmingsplannaam, b.opdrachtgever, b.opdrachtgever_namelijk, b.aanduiding, b.plantype, b.woonmilieu, b.woonmilieu_namelijk, b.gebruikgegevens,b.prognose_start,b.prognose_oplevering, b.statusplanologisch, b.statusproject, b.status_namelijk, b.alg_voortgang, b.alg_toelichting, b.plan_voortgang, b.plan_toelichting, b.start_voortgang, b.start_toelichting, b.bouwrijp_voortgang, b.bouwrijp_toelichting, b.vergunning_voortgang, b.vergunning_toelichting, b.overig_voortgang, b.overig_toelichting, COALESCE((( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND planningsaantal_capaciteit.factsoortid = 1))::numeric, 0::numeric) AS "2015Tot", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Huur 2015", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30]))), 0::bigint) AS "Koop 2015", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "EigOnb2015", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40]))), 0::bigint) AS "Eg_2015", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41]))), 0::bigint) AS "Mg_2015", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39]))), 0::bigint) AS "TypeOnb2015", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Soc_2015", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11]))), 0::bigint) AS "Markt 2015", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[2, 3, 4, 5, 6, 7])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "PriOnb2015", COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND (gepland_view.periodeid = ANY (ARRAY[8, 9, 10, 11, 12]))), 0::numeric) AS "15-19Tot", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Huur 15-19", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30]))), 0::bigint) AS "Koop 15-19", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "EigOnb15-19", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40]))), 0::bigint) AS "Eg_15-19", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41]))), 0::bigint) AS "Mg_15-19", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39]))), 0::bigint) AS "TypeOnb15-19", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Soc_15-19", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11]))), 0::bigint) AS "Markt 15-19", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND (planningsaantal_capaciteit.periodeid = ANY (ARRAY[8, 9, 10, 11, 12])) AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "PriOnb15-19", COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND gepland_view.periodeid = 13), 0::numeric) AS "20-24Tot", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 13 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Huur 20-24", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 13 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30]))), 0::bigint) AS "Koop 20-24", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 13 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "EigOnb20-24", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 13 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40]))), 0::bigint) AS "Eg_20-24", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 13 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41]))), 0::bigint) AS "Mg_20-24", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 13 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39]))), 0::bigint) AS "TypeOnb20-24", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 13 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Soc_20-24", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 13 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11]))), 0::bigint) AS "Markt 20-24", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 13 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "PriOnb20-24", COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND gepland_view.periodeid = 14), 0::numeric) AS "25-29Tot", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 14 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Huur 25-29", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 14 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30]))), 0::bigint) AS "Koop 25-29", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 14 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "EigOnb25-29", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 14 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40]))), 0::bigint) AS "Eg_25-29", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 14 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41]))), 0::bigint) AS "Mg_25-29", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 14 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39]))), 0::bigint) AS "TypeOnb25-29", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 14 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Soc_25-29", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 14 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11]))), 0::bigint) AS "Markt 25-29", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 14 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "PriOnb25-29", COALESCE(( SELECT sum(gepland_view.p_t) AS sum
           FROM gepland_view
          WHERE gepland_view.id = b.id AND gepland_view.periodeid = 16), 0::numeric) AS "30 evTot", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 16 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Huur 30 ev", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 16 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[12, 13, 14, 15, 16, 17, 24, 25, 26, 28, 29, 30]))), 0::bigint) AS "Koop 30 ev", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 16 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[18, 40, 41]))), 0::bigint) AS "EigOnb30 ev", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 16 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[3, 4, 5, 12, 13, 21, 24, 28, 31, 34, 37, 40]))), 0::bigint) AS "Eg_30 ev", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 16 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[6, 7, 8, 14, 15, 22, 25, 29, 32, 35, 38, 41]))), 0::bigint) AS "Mg_30 ev", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 16 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[9, 10, 11, 16, 17, 18, 23, 26, 30, 33, 36, 39]))), 0::bigint) AS "TypeOn30ev", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 16 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[12, 14, 16, 3, 6, 9, 4, 7, 10, 34, 35, 36, 37, 38, 39]))), 0::bigint) AS "Soc_30 ev", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 16 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[28, 29, 30, 31, 32, 33, 13, 15, 17, 5, 8, 11]))), 0::bigint) AS "Markt 30 ev", COALESCE(( SELECT sum(planningsaantal_capaciteit.planningaantal) AS sum
           FROM planningsaantal_capaciteit
          WHERE planningsaantal_capaciteit.bouwplanid = b.id AND planningsaantal_capaciteit.periodeid = 16 AND (planningsaantal_capaciteit.factsoortid = ANY (ARRAY[21, 22, 23, 24, 25, 26, 40, 41, 18]))), 0::bigint) AS "PriOnb30 ev"
   FROM volledig_overzicht_shape_view b;

ALTER TABLE pertype_overzicht_shape_view_plancapaciteit OWNER TO rwbp;


-- View: pertype_overzicht_view

--DROP VIEW pertype_overzicht_view;

CREATE OR REPLACE VIEW pertype_overzicht_view AS 
 SELECT pertype_overzicht_shape_view.id, pertype_overzicht_shape_view.naam, pertype_overzicht_shape_view.referentienummer, pertype_overzicht_shape_view.masterplan, pertype_overzicht_shape_view.bestemmingsplannaam, pertype_overzicht_shape_view.opdrachtgever, pertype_overzicht_shape_view.opdrachtgever_namelijk, pertype_overzicht_shape_view.aanduiding, pertype_overzicht_shape_view.plantype, pertype_overzicht_shape_view.woonmilieu, pertype_overzicht_shape_view.woonmilieu_namelijk, pertype_overzicht_shape_view.gebruikgegevens, pertype_overzicht_shape_view.prognose_start, pertype_overzicht_shape_view.prognose_oplevering, pertype_overzicht_shape_view.statusplanologisch, pertype_overzicht_shape_view.statusproject, pertype_overzicht_shape_view.status_namelijk, pertype_overzicht_shape_view.alg_voortgang, pertype_overzicht_shape_view.alg_toelichting, pertype_overzicht_shape_view.plan_voortgang, pertype_overzicht_shape_view.plan_toelichting, pertype_overzicht_shape_view.start_voortgang, pertype_overzicht_shape_view.start_toelichting, pertype_overzicht_shape_view.bouwrijp_voortgang, pertype_overzicht_shape_view.bouwrijp_toelichting, pertype_overzicht_shape_view.vergunning_voortgang, pertype_overzicht_shape_view.vergunning_toelichting, pertype_overzicht_shape_view.overig_voortgang, pertype_overzicht_shape_view.overig_toelichting, pertype_overzicht_shape_view."2015Totaal", pertype_overzicht_shape_view."Huur 2015", pertype_overzicht_shape_view."Koop 2015", pertype_overzicht_shape_view."EigOnb2015", pertype_overzicht_shape_view."Eg_2015", pertype_overzicht_shape_view."Mg_2015", pertype_overzicht_shape_view."TypeOnb2015", pertype_overzicht_shape_view."Soc_2015", pertype_overzicht_shape_view."Markt 2015", pertype_overzicht_shape_view."PriOnb2015", pertype_overzicht_shape_view."15-19Tot", pertype_overzicht_shape_view."Huur 15-19", pertype_overzicht_shape_view."Koop 15-19", pertype_overzicht_shape_view."EigOnb15-19", pertype_overzicht_shape_view."Eg_15-19", pertype_overzicht_shape_view."Mg_15-19", pertype_overzicht_shape_view."TypeOnb15-19", pertype_overzicht_shape_view."Soc_15-19", pertype_overzicht_shape_view."Markt15-19", pertype_overzicht_shape_view."PriOnb15-19", pertype_overzicht_shape_view."20-24Tot", pertype_overzicht_shape_view."Huur 20-24", pertype_overzicht_shape_view."Koop 20-24", pertype_overzicht_shape_view."EigOnb20-24", pertype_overzicht_shape_view."Eg_20-24", pertype_overzicht_shape_view."Mg_20-24", pertype_overzicht_shape_view."TypeOnb20-24", pertype_overzicht_shape_view."Soc_20-24", pertype_overzicht_shape_view."Markt 20-24", pertype_overzicht_shape_view."PriOnb20-24", pertype_overzicht_shape_view."25-29Tot", pertype_overzicht_shape_view."Huur 25-29", pertype_overzicht_shape_view."Koop 25-29", pertype_overzicht_shape_view."EigOnb25-29", pertype_overzicht_shape_view."Eg_25-29", pertype_overzicht_shape_view."Mg_25-29", pertype_overzicht_shape_view."TypeOnb25-29", pertype_overzicht_shape_view."Soc_25-29", pertype_overzicht_shape_view."Markt 25-29", pertype_overzicht_shape_view."PriOnb25-29", pertype_overzicht_shape_view."30 ev tot", pertype_overzicht_shape_view."Huur 30 ev", pertype_overzicht_shape_view."Koop 30 ev", pertype_overzicht_shape_view."EigOnb30 ev", pertype_overzicht_shape_view."Eg_30 ev", pertype_overzicht_shape_view."Mg_30 ev", pertype_overzicht_shape_view."TypeOnb30 ev", pertype_overzicht_shape_view."Soc_30 ev", pertype_overzicht_shape_view."Markt 30 ev", pertype_overzicht_shape_view."PriOnb30 ev"
   FROM pertype_overzicht_shape_view;

ALTER TABLE pertype_overzicht_view OWNER TO rwbp;


-- View: pertype_overzicht_view_plancapaciteit

--DROP VIEW pertype_overzicht_view_plancapaciteit;

CREATE OR REPLACE VIEW pertype_overzicht_view_plancapaciteit AS 
 SELECT pertype_overzicht_shape_view_plancapaciteit.id, pertype_overzicht_shape_view_plancapaciteit.naam, pertype_overzicht_shape_view_plancapaciteit.referentienummer, pertype_overzicht_shape_view_plancapaciteit.masterplan, pertype_overzicht_shape_view_plancapaciteit.bestemmingsplannaam, pertype_overzicht_shape_view_plancapaciteit.opdrachtgever, pertype_overzicht_shape_view_plancapaciteit.opdrachtgever_namelijk, pertype_overzicht_shape_view_plancapaciteit.aanduiding, pertype_overzicht_shape_view_plancapaciteit.plantype, pertype_overzicht_shape_view_plancapaciteit.woonmilieu, pertype_overzicht_shape_view_plancapaciteit.woonmilieu_namelijk, pertype_overzicht_shape_view_plancapaciteit.gebruikgegevens,pertype_overzicht_shape_view_plancapaciteit.prognose_start, pertype_overzicht_shape_view_plancapaciteit.prognose_oplevering, pertype_overzicht_shape_view_plancapaciteit.statusplanologisch, pertype_overzicht_shape_view_plancapaciteit.statusproject, pertype_overzicht_shape_view_plancapaciteit.status_namelijk, pertype_overzicht_shape_view_plancapaciteit.alg_voortgang, pertype_overzicht_shape_view_plancapaciteit.alg_toelichting, pertype_overzicht_shape_view_plancapaciteit.plan_voortgang, pertype_overzicht_shape_view_plancapaciteit.plan_toelichting, pertype_overzicht_shape_view_plancapaciteit.start_voortgang, pertype_overzicht_shape_view_plancapaciteit.start_toelichting, pertype_overzicht_shape_view_plancapaciteit.bouwrijp_voortgang, pertype_overzicht_shape_view_plancapaciteit.bouwrijp_toelichting, pertype_overzicht_shape_view_plancapaciteit.vergunning_voortgang, pertype_overzicht_shape_view_plancapaciteit.vergunning_toelichting, pertype_overzicht_shape_view_plancapaciteit.overig_voortgang, pertype_overzicht_shape_view_plancapaciteit.overig_toelichting, pertype_overzicht_shape_view_plancapaciteit."2015Tot", pertype_overzicht_shape_view_plancapaciteit."Huur 2015", pertype_overzicht_shape_view_plancapaciteit."Koop 2015", pertype_overzicht_shape_view_plancapaciteit."EigOnb2015", pertype_overzicht_shape_view_plancapaciteit."Eg_2015", pertype_overzicht_shape_view_plancapaciteit."Mg_2015", pertype_overzicht_shape_view_plancapaciteit."TypeOnb2015", pertype_overzicht_shape_view_plancapaciteit."Soc_2015", pertype_overzicht_shape_view_plancapaciteit."Markt 2015", pertype_overzicht_shape_view_plancapaciteit."PriOnb2015", pertype_overzicht_shape_view_plancapaciteit."15-19Tot", pertype_overzicht_shape_view_plancapaciteit."Huur 15-19", pertype_overzicht_shape_view_plancapaciteit."Koop 15-19", pertype_overzicht_shape_view_plancapaciteit."EigOnb15-19", pertype_overzicht_shape_view_plancapaciteit."Eg_15-19", pertype_overzicht_shape_view_plancapaciteit."Mg_15-19", pertype_overzicht_shape_view_plancapaciteit."TypeOnb15-19", pertype_overzicht_shape_view_plancapaciteit."Soc_15-19", pertype_overzicht_shape_view_plancapaciteit."Markt 15-19", pertype_overzicht_shape_view_plancapaciteit."PriOnb15-19", pertype_overzicht_shape_view_plancapaciteit."20-24Tot", pertype_overzicht_shape_view_plancapaciteit."Huur 20-24", pertype_overzicht_shape_view_plancapaciteit."Koop 20-24", pertype_overzicht_shape_view_plancapaciteit."EigOnb20-24", pertype_overzicht_shape_view_plancapaciteit."Eg_20-24", pertype_overzicht_shape_view_plancapaciteit."Mg_20-24", pertype_overzicht_shape_view_plancapaciteit."TypeOnb20-24", pertype_overzicht_shape_view_plancapaciteit."Soc_20-24", pertype_overzicht_shape_view_plancapaciteit."Markt 20-24", pertype_overzicht_shape_view_plancapaciteit."PriOnb20-24", pertype_overzicht_shape_view_plancapaciteit."25-29Tot", pertype_overzicht_shape_view_plancapaciteit."Huur 25-29", pertype_overzicht_shape_view_plancapaciteit."Koop 25-29", pertype_overzicht_shape_view_plancapaciteit."EigOnb25-29", pertype_overzicht_shape_view_plancapaciteit."Eg_25-29", pertype_overzicht_shape_view_plancapaciteit."Mg_25-29", pertype_overzicht_shape_view_plancapaciteit."TypeOnb25-29", pertype_overzicht_shape_view_plancapaciteit."Soc_25-29", pertype_overzicht_shape_view_plancapaciteit."Markt 25-29", pertype_overzicht_shape_view_plancapaciteit."PriOnb25-29", pertype_overzicht_shape_view_plancapaciteit."30 evTot", pertype_overzicht_shape_view_plancapaciteit."Huur 30 ev", pertype_overzicht_shape_view_plancapaciteit."Koop 30 ev", pertype_overzicht_shape_view_plancapaciteit."EigOnb30 ev", pertype_overzicht_shape_view_plancapaciteit."Eg_30 ev", pertype_overzicht_shape_view_plancapaciteit."Mg_30 ev", pertype_overzicht_shape_view_plancapaciteit."TypeOn30ev", pertype_overzicht_shape_view_plancapaciteit."Soc_30 ev", pertype_overzicht_shape_view_plancapaciteit."Markt 30 ev", pertype_overzicht_shape_view_plancapaciteit."PriOnb30 ev"
   FROM pertype_overzicht_shape_view_plancapaciteit;

ALTER TABLE pertype_overzicht_view_plancapaciteit OWNER TO rwbp;

-- View: volledig_aantal_view

--DROP VIEW volledig_aantal_view;

CREATE OR REPLACE VIEW volledig_aantal_view AS 
 SELECT gep.id, gep.periodeid, gep.omschrijving, gep.p_t, gep.p_h_eg_g, gep.p_h_eg_s, gep.p_h_eg_s3, gep.p_h_eg_s4, gep.p_h_eg_m, gep.p_h_eg_m2, gep.p_h_eg_o, gep.p_h_mg_g, gep.p_h_mg_s, gep.p_h_mg_s3, gep.p_h_mg_s4, gep.p_h_mg_m, gep.p_h_mg_m2, gep.p_h_mg_o, gep.p_h_on_g, gep.p_h_on_s, gep.p_h_on_s3, gep.p_h_on_s4, gep.p_h_on_m, gep.p_h_on_m2, gep.p_h_on_o, gep.p_k_eg_s, gep.p_k_eg_m, gep.p_k_eg_m2, gep.p_k_eg_o, gep.p_k_mg_s, gep.p_k_mg_m, gep.p_k_mg_m2, gep.p_k_mg_o, gep.p_k_on_s, gep.p_k_on_m, gep.p_k_on_m2, gep.p_k_on_o, gep.p_o_eg, gep.p_o_mg, gep.p_o_o, gep.p_s, ger.omschrijving AS gerealiseerd_omschrijving, ger.r_t, ger.r_h_eg_g, ger.r_h_eg_m, ger.r_h_eg_o, ger.r_h_eg_s, ger.r_h_mg_g, ger.r_h_mg_m, ger.r_h_mg_o, ger.r_h_mg_s, ger.r_h_on_g, ger.r_h_on_m, ger.r_h_on_o, ger.r_h_on_s, ger.r_k_eg_m, ger.r_k_eg_o, ger.r_k_eg_s, ger.r_k_mg_m, ger.r_k_mg_o, ger.r_k_mg_s, ger.r_k_on_m, ger.r_k_on_o, ger.r_k_on_s, ger.r_o, ger.r_s
   FROM gepland_view gep
   JOIN gerealiseerd_view ger ON ger.id = gep.id AND ger.periodeid = gep.periodeid;

ALTER TABLE volledig_aantal_view OWNER TO rwbp;


-- View: planningperperiode_overzicht_shape_view

--DROP VIEW planningperperiode_overzicht_shape_view;

CREATE OR REPLACE VIEW planningperperiode_overzicht_shape_view AS 
 SELECT b.the_geom, b.id, b.naam, b.referentienummer, b.masterplan, b.bestemmingsplannaam, b.opdrachtgever, b.opdrachtgever_namelijk, b.aanduiding, b.plantype, b.woonmilieu, b.woonmilieu_namelijk, b.gebruikgegevens, b.prognose_start, b.prognose_oplevering, b.statusplanologisch, b.statusproject, b.status_namelijk, b.alg_voortgang, b.alg_toelichting, b.plan_voortgang, b.plan_toelichting, b.start_voortgang, b.start_toelichting, b.bouwrijp_voortgang, b.bouwrijp_toelichting, b.vergunning_voortgang, b.vergunning_toelichting, b.overig_voortgang, b.overig_toelichting, COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE aan.id = b.id AND aan.periodeid = 2), 0::bigint) AS "Nb_2009 en eerder", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 3), 0::bigint) AS "Nb_2010", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 4), 0::bigint) AS "Nb_2011", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 5), 0::bigint) AS "Nb_2012", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 6), 0::bigint) AS "Nb_2013", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 7), 0::bigint) AS "Nb_2014", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 8), 0::bigint) AS "Nb_2015", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 9), 0::bigint) AS "Nb_2016", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 10), 0::bigint) AS "Nb_2017", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 11), 0::bigint) AS "Nb_2018", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 12), 0::bigint) AS "Nb_2019", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 13), 0::bigint) AS "Nb_20-24", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 14), 0::bigint) AS "Nb_25-9", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 16), 0::bigint) AS "Nb_2030_ev", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 17), 0::bigint) AS "Nb_Onb", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE aan.id = b.id AND aan.periodeid = 2), 0) AS "Sl_2009_ev", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 3), 0) AS "Sl_2010", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 4), 0) AS "Sl_2011", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 5), 0) AS "Sl_2012", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 6), 0) AS "Sl_2013", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 7), 0) AS "Sl_2014", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 8), 0) AS "Sl_2015", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 9), 0) AS "Sl_2016", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 10), 0) AS "Sl_2017", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 11), 0) AS "Sl_2018", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 12), 0) AS "Sl_2019", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 13), 0) AS "Sl_20-24", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 14), 0) AS "Sl_25-29", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 16), 0) AS "Sl_2030_ev", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view aan
          WHERE b.id = aan.id AND aan.periodeid = 17), 0) AS "Sl_Onb"
   FROM volledig_overzicht_shape_view b;

ALTER TABLE planningperperiode_overzicht_shape_view OWNER TO rwbp;

-- View: volledig_aantal_view_plancapaciteit

--DROP VIEW volledig_aantal_view_plancapaciteit;

CREATE OR REPLACE VIEW volledig_aantal_view_plancapaciteit AS 
 SELECT gep.id, gep.periodeid, gep.omschrijving, gep.p_t, gep.p_h_eg_g, gep.p_h_eg_s, gep.p_h_eg_s3, gep.p_h_eg_s4, gep.p_h_eg_m, gep.p_h_eg_m2, gep.p_h_eg_o, gep.p_h_mg_g, gep.p_h_mg_s, gep.p_h_mg_s3, gep.p_h_mg_s4, gep.p_h_mg_m, gep.p_h_mg_m2, gep.p_h_mg_o, gep.p_h_on_g, gep.p_h_on_s, gep.p_h_on_s3, gep.p_h_on_s4, gep.p_h_on_m, gep.p_h_on_m2, gep.p_h_on_o, gep.p_k_eg_s, gep.p_k_eg_m, gep.p_k_eg_m2, gep.p_k_eg_o, gep.p_k_mg_s, gep.p_k_mg_m, gep.p_k_mg_m2, gep.p_k_mg_o, gep.p_k_on_s, gep.p_k_on_m, gep.p_k_on_m2, gep.p_k_on_o, gep.p_o_eg, gep.p_o_mg, gep.p_o_o, gep.p_s, ger.omschrijving AS gerealiseerd_omschrijving, ger.r_t, ger.r_h_eg_g, ger.r_h_eg_m, ger.r_h_eg_o, ger.r_h_eg_s, ger.r_h_mg_g, ger.r_h_mg_m, ger.r_h_mg_o, ger.r_h_mg_s, ger.r_h_on_g, ger.r_h_on_m, ger.r_h_on_o, ger.r_h_on_s, ger.r_k_eg_m, ger.r_k_eg_o, ger.r_k_eg_s, ger.r_k_mg_m, ger.r_k_mg_o, ger.r_k_mg_s, ger.r_k_on_m, ger.r_k_on_o, ger.r_k_on_s, ger.r_o, ger.r_s
   FROM gepland_view_plancapaciteit gep
   JOIN gerealiseerd_view ger ON ger.id = gep.id AND ger.periodeid = gep.periodeid;

ALTER TABLE volledig_aantal_view_plancapaciteit OWNER TO postgres;

-- View: planningperperiode_overzicht_shape_view_plancapaciteit

--DROP VIEW planningperperiode_overzicht_shape_view_plancapaciteit;

CREATE OR REPLACE VIEW planningperperiode_overzicht_shape_view_plancapaciteit AS 
 SELECT b.the_geom, b.id, b.naam, b.referentienummer, b.masterplan, b.bestemmingsplannaam, b.opdrachtgever, b.opdrachtgever_namelijk, b.aanduiding, b.plantype, b.woonmilieu, b.woonmilieu_namelijk, b.gebruikgegevens, b.prognose_start,b.prognose_oplevering, b.statusplanologisch, b.statusproject, b.status_namelijk, b.alg_voortgang, b.alg_toelichting, b.plan_voortgang, b.plan_toelichting, b.start_voortgang, b.start_toelichting, b.bouwrijp_voortgang, b.bouwrijp_toelichting, b.vergunning_voortgang, b.vergunning_toelichting, b.overig_voortgang, b.overig_toelichting, COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE aan.id = b.id AND aan.periodeid = 2), 0::bigint) AS "Nb_2009_ev", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 3), 0::bigint) AS "Nb_2010", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 4), 0::bigint) AS "Nb_2011", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 5), 0::bigint) AS "Nb_2012", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 6), 0::bigint) AS "Nb_2013", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 7), 0::bigint) AS "Nb_2014", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 8), 0::bigint) AS "Nb_2015", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 9), 0::bigint) AS "Nb_2016", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 10), 0::bigint) AS "Nb_2017", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 11), 0::bigint) AS "Nb_2018", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 12), 0::bigint) AS "Nb_2019", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 13), 0::bigint) AS "Nb_20-24", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 14), 0::bigint) AS "Nb_25-29", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 16), 0::bigint) AS "Nb_2030_ev", COALESCE(( SELECT aan.p_t
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 17), 0::bigint) AS "Nb_Onb", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE aan.id = b.id AND aan.periodeid = 2), 0) AS "Sl_2009_ev", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 3), 0) AS "Sl_2010", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 4), 0) AS "Sl_2011", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 5), 0) AS "Sl_2012", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 6), 0) AS "Sl_2013", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 7), 0) AS "Sl_2014", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 8), 0) AS "Sl_2015", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 9), 0) AS "Sl_2016", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 10), 0) AS "Sl_2017", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 11), 0) AS "Sl_2018", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 12), 0) AS "Sl_2019", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 13), 0) AS "Sl_2020-2024", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 14), 0) AS "Sl_2025-2029", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 16), 0) AS "Sl_2030 en verder", COALESCE(( SELECT aan.p_s
           FROM volledig_aantal_view_plancapaciteit aan
          WHERE b.id = aan.id AND aan.periodeid = 17), 0) AS "Sl_Onb"
   FROM volledig_overzicht_shape_view b;

ALTER TABLE planningperperiode_overzicht_shape_view_plancapaciteit OWNER TO rwbp;

-- View: planningperperiode_overzicht_view

--DROP VIEW planningperperiode_overzicht_view;

CREATE OR REPLACE VIEW planningperperiode_overzicht_view AS 
 SELECT planningperperiode_overzicht_shape_view.id, planningperperiode_overzicht_shape_view.naam, planningperperiode_overzicht_shape_view.referentienummer, planningperperiode_overzicht_shape_view.masterplan, planningperperiode_overzicht_shape_view.bestemmingsplannaam, planningperperiode_overzicht_shape_view.opdrachtgever, planningperperiode_overzicht_shape_view.opdrachtgever_namelijk, planningperperiode_overzicht_shape_view.aanduiding, planningperperiode_overzicht_shape_view.plantype, planningperperiode_overzicht_shape_view.woonmilieu, planningperperiode_overzicht_shape_view.woonmilieu_namelijk, planningperperiode_overzicht_shape_view.gebruikgegevens, planningperperiode_overzicht_shape_view.prognose_start,planningperperiode_overzicht_shape_view.prognose_oplevering, planningperperiode_overzicht_shape_view.statusplanologisch, planningperperiode_overzicht_shape_view.statusproject, planningperperiode_overzicht_shape_view.status_namelijk, planningperperiode_overzicht_shape_view.alg_voortgang, planningperperiode_overzicht_shape_view.alg_toelichting, planningperperiode_overzicht_shape_view.plan_voortgang, planningperperiode_overzicht_shape_view.plan_toelichting, planningperperiode_overzicht_shape_view.start_voortgang, planningperperiode_overzicht_shape_view.start_toelichting, planningperperiode_overzicht_shape_view.bouwrijp_voortgang, planningperperiode_overzicht_shape_view.bouwrijp_toelichting, planningperperiode_overzicht_shape_view.vergunning_voortgang, planningperperiode_overzicht_shape_view.vergunning_toelichting, planningperperiode_overzicht_shape_view.overig_voortgang, planningperperiode_overzicht_shape_view.overig_toelichting, planningperperiode_overzicht_shape_view."Nb_2009 en eerder", planningperperiode_overzicht_shape_view."Nb_2010", planningperperiode_overzicht_shape_view."Nb_2011", planningperperiode_overzicht_shape_view."Nb_2012", planningperperiode_overzicht_shape_view."Nb_2013", planningperperiode_overzicht_shape_view."Nb_2014", planningperperiode_overzicht_shape_view."Nb_2015", planningperperiode_overzicht_shape_view."Nb_2016", planningperperiode_overzicht_shape_view."Nb_2017", planningperperiode_overzicht_shape_view."Nb_2018", planningperperiode_overzicht_shape_view."Nb_2019", planningperperiode_overzicht_shape_view."Nb_20-24", planningperperiode_overzicht_shape_view."Nb_25-9", planningperperiode_overzicht_shape_view."Nb_2030_ev", planningperperiode_overzicht_shape_view."Nb_Onb", planningperperiode_overzicht_shape_view."Sl_2009_ev", planningperperiode_overzicht_shape_view."Sl_2010", planningperperiode_overzicht_shape_view."Sl_2011", planningperperiode_overzicht_shape_view."Sl_2012", planningperperiode_overzicht_shape_view."Sl_2013", planningperperiode_overzicht_shape_view."Sl_2014", planningperperiode_overzicht_shape_view."Sl_2015", planningperperiode_overzicht_shape_view."Sl_2016", planningperperiode_overzicht_shape_view."Sl_2017", planningperperiode_overzicht_shape_view."Sl_2018", planningperperiode_overzicht_shape_view."Sl_2019", planningperperiode_overzicht_shape_view."Sl_20-24", planningperperiode_overzicht_shape_view."Sl_25-29", planningperperiode_overzicht_shape_view."Sl_2030_ev", planningperperiode_overzicht_shape_view."Sl_Onb"
   FROM planningperperiode_overzicht_shape_view;

ALTER TABLE planningperperiode_overzicht_view OWNER TO rwbp;


-- View: planningperperiode_overzicht_view_plancapaciteit

--DROP VIEW planningperperiode_overzicht_view_plancapaciteit;

CREATE OR REPLACE VIEW planningperperiode_overzicht_view_plancapaciteit AS 
 SELECT planningperperiode_overzicht_shape_view_plancapaciteit.id, planningperperiode_overzicht_shape_view_plancapaciteit.naam, planningperperiode_overzicht_shape_view_plancapaciteit.referentienummer, planningperperiode_overzicht_shape_view_plancapaciteit.masterplan, planningperperiode_overzicht_shape_view_plancapaciteit.bestemmingsplannaam, planningperperiode_overzicht_shape_view_plancapaciteit.opdrachtgever, planningperperiode_overzicht_shape_view_plancapaciteit.opdrachtgever_namelijk, planningperperiode_overzicht_shape_view_plancapaciteit.aanduiding, planningperperiode_overzicht_shape_view_plancapaciteit.plantype, planningperperiode_overzicht_shape_view_plancapaciteit.woonmilieu, planningperperiode_overzicht_shape_view_plancapaciteit.woonmilieu_namelijk, planningperperiode_overzicht_shape_view_plancapaciteit.gebruikgegevens, planningperperiode_overzicht_shape_view_plancapaciteit.prognose_start,planningperperiode_overzicht_shape_view_plancapaciteit.prognose_oplevering, planningperperiode_overzicht_shape_view_plancapaciteit.statusplanologisch, planningperperiode_overzicht_shape_view_plancapaciteit.statusproject, planningperperiode_overzicht_shape_view_plancapaciteit.status_namelijk, planningperperiode_overzicht_shape_view_plancapaciteit.alg_voortgang, planningperperiode_overzicht_shape_view_plancapaciteit.alg_toelichting, planningperperiode_overzicht_shape_view_plancapaciteit.plan_voortgang, planningperperiode_overzicht_shape_view_plancapaciteit.plan_toelichting, planningperperiode_overzicht_shape_view_plancapaciteit.start_voortgang, planningperperiode_overzicht_shape_view_plancapaciteit.start_toelichting, planningperperiode_overzicht_shape_view_plancapaciteit.bouwrijp_voortgang, planningperperiode_overzicht_shape_view_plancapaciteit.bouwrijp_toelichting, planningperperiode_overzicht_shape_view_plancapaciteit.vergunning_voortgang, planningperperiode_overzicht_shape_view_plancapaciteit.vergunning_toelichting, planningperperiode_overzicht_shape_view_plancapaciteit.overig_voortgang, planningperperiode_overzicht_shape_view_plancapaciteit.overig_toelichting, planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2009_ev", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2010", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2011", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2012", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2013", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2014", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2015", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2016", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2017", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2018", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2019", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_20-24", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_25-29", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_2030_ev", planningperperiode_overzicht_shape_view_plancapaciteit."Nb_Onb", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2009_ev", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2010", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2011", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2012", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2013", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2014", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2015", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2016", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2017", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2018", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2019", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2020-2024", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2025-2029", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_2030 en verder", planningperperiode_overzicht_shape_view_plancapaciteit."Sl_Onb"
   FROM planningperperiode_overzicht_shape_view_plancapaciteit;

ALTER TABLE planningperperiode_overzicht_view_plancapaciteit OWNER TO rwbp;

-- View: shape_view

--DROP VIEW shape_view;
/*
CREATE OR REPLACE VIEW shape_view AS 
 SELECT b.the_geom, b.id, b.naam AS plannaam, g.naam AS gemeente, r.naam AS regio, b.gebruikeractiontijd AS "laatste wijziging", ( SELECT sum(f.planningaantal) AS sum
           FROM factmetperiode f
          WHERE f.bouwplanid = b.id AND f.factsoortid <> 1 AND f.factsoortid <> 2 AND f.factsoortid <> 19 AND f.factsoortid <> 27) AS "aantal gepland"
   FROM bouwplan b
   LEFT JOIN gemeente g ON g.id = b.gemeenteid
   LEFT JOIN regio r ON r.id = g.regioid
  WHERE b.statusprojectid <> 11 AND b.the_geom IS NOT NULL
  ORDER BY b.id;

ALTER TABLE shape_view OWNER TO rwbp;*/

-- View: volledig_extravelden_view

--DROP VIEW volledig_extravelden_view;

CREATE OR REPLACE VIEW volledig_extravelden_view AS 
 SELECT ger.id, ger.jaar, ger.extraveldsoort, ger.waarde AS gerealiseerd_waarde, gep.waarde AS gepland_waarde
   FROM extragepland_view gep
   JOIN extragerealiseerd_view ger ON ger.id = gep.id;

ALTER TABLE volledig_extravelden_view OWNER TO rwbp;


-- View: volledig_overzicht_view

--DROP VIEW volledig_overzicht_view;

CREATE OR REPLACE VIEW volledig_overzicht_view AS 
 SELECT volledig_overzicht_shape_view.id, volledig_overzicht_shape_view.naam, volledig_overzicht_shape_view.referentienummer, volledig_overzicht_shape_view.masterplan, volledig_overzicht_shape_view.bestemmingsplannaam, volledig_overzicht_shape_view.opdrachtgever, volledig_overzicht_shape_view.opdrachtgever_namelijk, volledig_overzicht_shape_view.aanduiding, volledig_overzicht_shape_view.plantype, volledig_overzicht_shape_view.woonmilieu, volledig_overzicht_shape_view.woonmilieu_namelijk, volledig_overzicht_shape_view.gebruikgegevens, volledig_overzicht_shape_view.prognose_start, volledig_overzicht_shape_view.prognose_oplevering, volledig_overzicht_shape_view.statusplanologisch, volledig_overzicht_shape_view.statusproject, volledig_overzicht_shape_view.status_namelijk, volledig_overzicht_shape_view.alg_voortgang, volledig_overzicht_shape_view.alg_toelichting, volledig_overzicht_shape_view.plan_voortgang, volledig_overzicht_shape_view.plan_toelichting, volledig_overzicht_shape_view.start_voortgang, volledig_overzicht_shape_view.start_toelichting, volledig_overzicht_shape_view.bouwrijp_voortgang, volledig_overzicht_shape_view.bouwrijp_toelichting, volledig_overzicht_shape_view.vergunning_voortgang, volledig_overzicht_shape_view.vergunning_toelichting, volledig_overzicht_shape_view.overig_voortgang, volledig_overzicht_shape_view.overig_toelichting
   FROM volledig_overzicht_shape_view;

ALTER TABLE volledig_overzicht_view OWNER TO rwbp;


-- View: rapportage_pertype_view

--DROP VIEW rapportage_pertype_view;

CREATE OR REPLACE VIEW rapportage_pertype_view AS 
 SELECT g.naam AS gemeentenaam, b.naam, aant.statusplanologisch, aant.statusproject, aant.alg_voortgang, (aant."2015Totaal" + aant."15-19Tot" + aant."20-24Tot" + aant."25-29Tot" + aant."30 ev tot")::bigint AS "Nieuwbouw totaal", aant."Huur 2015" + aant."Huur 15-19" + aant."Huur 20-24" + aant."Huur 25-29" + aant."Huur 30 ev" AS huur, aant."Koop 2015" + aant."Koop 15-19" + aant."Koop 20-24" + aant."Koop 25-29" + aant."Koop 30 ev" AS koop, aant."EigOnb2015" + aant."EigOnb15-19" + aant."EigOnb20-24" + aant."EigOnb25-29" + aant."EigOnb30 ev" AS "Eigendom onbekend", aant."Eg_2015" + aant."Eg_15-19" + aant."Eg_20-24" + aant."Eg_25-29" + aant."Eg_30 ev" AS eengezins, aant."Mg_2015" + aant."Mg_15-19" + aant."Mg_20-24" + aant."Mg_25-29" + aant."Mg_30 ev" AS meergezins, aant."TypeOnb2015" + aant."TypeOnb15-19" + aant."TypeOnb20-24" + aant."TypeOnb25-29" + aant."TypeOnb30 ev" AS "Type onbekend", b.id
   FROM pertype_overzicht_view aant
   JOIN bouwplan b ON b.id = aant.id
   JOIN gemeente g ON g.id = b.gemeenteid;

ALTER TABLE rapportage_pertype_view OWNER TO rwbp;

-- View: rapportage_pertype_view_plancapaciteit

--DROP VIEW rapportage_pertype_view_plancapaciteit;

CREATE OR REPLACE VIEW rapportage_pertype_view_plancapaciteit AS 
 SELECT g.naam AS gemeentenaam, b.naam, aant.statusplanologisch, aant.statusproject, aant.alg_voortgang, (aant."2015Tot" + aant."15-19Tot" + aant."20-24Tot" + aant."25-29Tot" + aant."30 evTot")::bigint AS "Nieuwbouw totaal", aant."Huur 2015" + aant."Huur 15-19" + aant."Huur 20-24" + aant."Huur 25-29" + aant."Huur 30 ev" AS huur, aant."Koop 2015" + aant."Koop 15-19" + aant."Koop 20-24" + aant."Koop 25-29" + aant."Koop 30 ev" AS koop, aant."EigOnb2015" + aant."EigOnb15-19" + aant."EigOnb20-24" + aant."EigOnb25-29" + aant."EigOnb30 ev" AS "Eigendom onbekend", aant."Eg_2015" + aant."Eg_15-19" + aant."Eg_20-24" + aant."Eg_25-29" + aant."Eg_30 ev" AS eengezins, aant."Mg_2015" + aant."Mg_15-19" + aant."Mg_20-24" + aant."Mg_25-29" + aant."Mg_30 ev" AS meergezins, aant."TypeOnb2015" + aant."TypeOnb15-19" + aant."TypeOnb20-24" + aant."TypeOnb25-29" + aant."TypeOn30ev" AS "Type onbekend", b.id
   FROM pertype_overzicht_view_plancapaciteit aant
   JOIN bouwplan b ON b.id = aant.id
   JOIN gemeente g ON g.id = b.gemeenteid;

ALTER TABLE rapportage_pertype_view_plancapaciteit OWNER TO rwbp;
-- View: rapportage_planningperperiode_view

--DROP VIEW rapportage_planningperperiode_view;

CREATE OR REPLACE VIEW rapportage_planningperperiode_view AS 
 SELECT g.naam AS gemeentenaam, b.naam, aant.statusplanologisch, aant.statusproject, aant.alg_voortgang, aant."2015Tot"::bigint AS "2015Tot", aant."15-19Tot"::bigint AS "15-19Tot", aant."20-24Tot"::bigint AS "20-24Tot", aant."25-29Tot"::bigint AS "25-29Tot", aant."30 evTot"::bigint AS "30 evTot", b.id
   FROM pertype_overzicht_view_plancapaciteit aant
   JOIN bouwplan b ON b.id = aant.id
   JOIN gemeente g ON g.id = b.gemeenteid;

ALTER TABLE rapportage_planningperperiode_view OWNER TO rwbp;

-- View: rapportage_planningperperiode_view_plancapaciteit

--DROP VIEW rapportage_planningperperiode_view_plancapaciteit;

CREATE OR REPLACE VIEW rapportage_planningperperiode_view_plancapaciteit AS 
 SELECT g.naam AS gemeentenaam, b.naam, aant.statusplanologisch, aant.statusproject, aant.alg_voortgang, aant."2015Tot"::bigint AS "2015Tot", aant."15-19Tot"::bigint AS "15-19Tot", aant."20-24Tot"::bigint AS "20-24Tot", aant."25-29Tot"::bigint AS "25-29Tot", aant."30 evTot"::bigint AS "30 evTot", b.id
   FROM pertype_overzicht_view_plancapaciteit aant
   JOIN bouwplan b ON b.id = aant.id
   JOIN gemeente g ON g.id = b.gemeenteid;

ALTER TABLE rapportage_planningperperiode_view_plancapaciteit OWNER TO rwbp;




